/**
* \file: VideoChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample Video channel implementation
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <bdcl/GstreamerVideoSink.h>
#include <string>
#include <adit_logging.h>
#include "VideoChannel.h"
#include "BdclSmoketest.h"

LOG_IMPORT_CONTEXT(tbdcl)

namespace adit { namespace bdcl {


VideoChannel::VideoChannel(CoreCallbackDealer* inCallbackDealer)
{
    mVideoSink = new GstreamerVideoSink(this, inCallbackDealer);

    mVideoSink->setConfigItem("video-width", "800");
    mVideoSink->setConfigItem("video-height", "480");
    mVideoSink->setConfigItem("video-fps", "30");

    mVideoSink->initialize();
}

VideoChannel::~VideoChannel()
{
    mVideoSink->teardown();
    delete mVideoSink;

}

void VideoChannel::onFirstFrameRendered()
{
    LOG_INFO((tbdcl, "onFirstFrameRendered() is invoked"));
    AutoSmoketest::instance().setTestError(NOERROR);
}

void VideoChannel::configureCodec()
{
    mVideoSink->configureStream();
}

void VideoChannel::onVideoEncoderInitDone(unsigned int inWidth, unsigned int inHeight, unsigned int inFramerate)
{
    mVideoSink->setConfigItem("video-width", std::to_string(inWidth));
    mVideoSink->setConfigItem("video-height", std::to_string(inHeight));
    mVideoSink->setConfigItem("video-fps", std::to_string(inFramerate));

    std::string gstPipeline = "vpudec low-latency=true frame-plus=2 framedrop=false framerate-nu=" + std::to_string(inFramerate) +" dis-reorder=true ! "
            "gst_apx_sink display-width=" + std::to_string(inWidth) + " display-height=" + std::to_string(inHeight) + " sync=false qos=false max-lateness=3000000000";

    mVideoSink->setConfigItem("gstreamer-video-pipeline", gstPipeline);

    mVideoSink->playbackStart();
}

void VideoChannel::onConnectException(carlifeConnectException inConnectException)
{
    LOG_ERROR((tbdcl, "carlifeConnectException: %d on Video channel", static_cast<uint32_t>(inConnectException)));
}

void VideoChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_ERROR((tbdcl, "Error: %d on Video channel", static_cast<uint32_t>(inErrorCode)));
}
} } /*namespace adit { namespace bdcl { */



